#define MAX_LIGHTS 8
#define NUM_LIGHTS 3
out vec2 Vertex_UV;
out vec3 Vertex_Normal;
out vec3 Vertex_LightDir[MAX_LIGHTS];
out vec4 Vertex_EyeVec;
uniform float texturescale;

void main()
{
gl_Position = ftransform();
Vertex_UV = gl_MultiTexCoord0.xy * texturescale;
Vertex_Normal = gl_NormalMatrix * gl_Normal;
vec4 view_vertex = gl_ModelViewMatrix * gl_Vertex;
int i;
for (i=0; i<NUM_LIGHTS; ++i)
	{
		Vertex_LightDir[i] = gl_LightSource[i].position.xyz - view_vertex;
	}
Vertex_EyeVec = -view_vertex;
}

