'
' OpenB3D: GLSL Color+Normal+Specular Multi-Lights Shader Test 01
' by DarkGiver
' 08.2014
'
Framework angros.openb3d
AppTitle:String = "OpenB3D: GLSL Color+Normal+Specular Multi-Lights Shader Test 01"
xscreen = 1024
yscreen = 768
Graphics3D(xscreen, yscreen, 0, 2, 60, -1, False)

red = CreateSphere(8)
EntityColor red, 255, 0, 0
PositionEntity red, 0, 10, 0
ScaleEntity red, 0.1, 0.1, 0.1
EntityFX red, 1
red_light = CreateLight(2)
PositionEntity red_light, EntityX(red), EntityY(red), EntityZ(red)
LightRange red_light, 20
LightColor red_light, 255, 0, 0
EntityParent red, red_light

green = CreateSphere(8)
EntityColor green, 0, 255, 0
PositionEntity green, 0, 8, 0
ScaleEntity green, 0.1, 0.1, 0.1
EntityFX green, 1
green_light = CreateLight(2)
PositionEntity green_light, EntityX(green), EntityY(green), EntityZ(green)
LightRange green_light, 20
LightColor green_light, 0, 255, 0
EntityParent green, green_light

blue = CreateSphere(8)
EntityColor blue, 0, 0, 255
PositionEntity blue, 0, 9, 0
ScaleEntity blue, 0.1, 0.1, 0.1
EntityFX blue, 1
blue_light = CreateLight(2)
PositionEntity blue_light, EntityX(blue), EntityY(blue), EntityZ(blue)
LightRange blue_light, 20
LightColor blue_light, 0, 0, 255
EntityParent blue, blue_light

Local camera = CreateCamera()
PositionEntity camera, -20, 10, 0
CameraRange camera, 1, 10000

Global Ambient:Float = 0.3
Global Shininess:Float = 0.5

tex1 = LoadTexture("textures/wall_COLOR.png")
tex2 = LoadTexture("textures/wall_NORMAL.png")
tex3 = LoadTexture("textures/wall_SPEC.png")
shader = LoadShader("", "shaders/c_n_s_ml.vert", "shaders/c_n_s_ml.frag")
SetFloat (shader, "lightradius", 0.005)
SetFloat (shader, "texturescale", 1.0)
SetFloat4 (shader, "vambient", Ambient, Ambient, Ambient, Ambient)
ShaderTexture (shader, tex1, "colorMap", 0)
ShaderTexture (shader, tex2, "normalMap", 1)
ShaderTexture (shader, tex3, "specularMap", 2)

Local cube = CreateCube()
PositionEntity (cube, 0, 5, 0)
ScaleEntity cube, 2, 2, 2
EntityShininess (cube, Shininess)
ShadeEntity cube, shader

Local boule = CreateSphere(16)
PositionEntity (boule, -5, 2, 0)
ScaleEntity boule, 2, 2, 2
EntityShininess (boule, Shininess)
ShadeEntity boule, shader

Local ground = CreateCube()
PositionEntity (ground, 0, -2, 0)
ScaleEntity ground, 10, 0.25, 10
EntityShininess (ground, Shininess)
ShadeEntity ground, shader

MoveMouse GraphicsWidth() / 2, GraphicsHeight() / 2
mousespeed:Float = 0.5
camerasmoothness:Float = 4.5
PointEntity camera, boule

wiretoggle = -1
shadowtoggle = -1

While Not KeyHit(KEY_ESCAPE) And Not AppTerminate()
	TurnEntity (red_light, 0, -1, 0)
	MoveEntity (red_light, 0, 0, -0.1)
	TurnEntity (green_light, 0, 2, 0)
	MoveEntity (green_light, 0, 0, 0.1)
	TurnEntity (blue_light, 0, 1, 0)
	MoveEntity (blue_light, 0, 0, 0.1)
	
	CameraRange camera, 1, 120000
	CameraZoom camera,1
	
	If MouseDown(2)	
		mousing = True
			mxs:Float = CurveValue(MouseXSpeed() * mousespeed, mxs, camerasmoothness)
			mys:Float = CurveValue(MouseYSpeed() * mousespeed, mys, camerasmoothness)
			camxa:Float = camxa - mxs Mod 360
			camya:Float = camya + mys
			If camya < - 89 Then camya = -89
			If camya > 89 Then camya = 89
		
			RotateEntity camera, camya, camxa, 0.0
		Else 
		mousing=False
	EndIf
	
	If KeyDown(KEY_W) MoveEntity camera, 0, 0, 0.25
	If KeyDown(KEY_S) MoveEntity camera, 0, 0, -0.25
	If KeyDown(KEY_A) MoveEntity camera, -0.25, 0, 0
	If KeyDown(KEY_D) MoveEntity camera, 0.25, 0, 0
	
	If KeyHit(key_space) Then wiretoggle=-wiretoggle
	
	If wiretoggle = 1 Then Wireframe True Else Wireframe False
	
	If KeyHit (KEY_C)
	shadowtoggle = -shadowtoggle
		If shadowtoggle = -1
			FreeShadow c
			FreeShadow b
			FreeShadow g
		EndIf
		If shadowtoggle = 1
			c = CreateShadow (cube)
			b = CreateShadow (boule)
			g = CreateShadow (ground)
		EndIf
	EndIf

	'UpdateWorld()
	RenderWorld()
	renders = renders + 1
	
	'calcul des fps
	If MilliSecs() - old_ms >= 1000
		old_ms = MilliSecs()
		fps = renders
		renders = 0
	EndIf
		
	Text 10, 20, "FPS: " + FPS
	Text 10, 50, EntityX(camera) + " " + EntityY(camera) + " " + EntityZ(camera)
	Text 10, 80, "A/D/W/S = Camera move, RightMouse = Mouse Camera View, Space=Toggle Wireframe, C=Toggle Shadow"
	Flip; Cls

Wend

' for camera mouse look
Function CurveValue#(newvalue#, oldvalue#, increments)
	If increments >  1 Then oldvalue# = oldvalue# - (oldvalue# - newvalue#) / increments 
	If increments <= 1 Then oldvalue# = newvalue# 
	Return oldvalue# 
End Function

